<?php

namespace Themento\CSS;

class TMT_Front {

    public function __construct() {
        add_filter('login_headerurl',[$this, 'tmt_login_link']);
        add_action( 'login_enqueue_scripts', [$this, 'tmt_login_settings'] );
        add_filter( 'archive_template', [$this, 'get_custom_post_type_template'] );
        add_filter( 'single_template', [$this, 'get_single_post_type_template'] );
    }

	public function tmt_login_link() {
        return home_url();
    }

    public function tmt_login_settings() {

        $category = 'login-settings';
        $login_logo = TMT_Get_Setting($category, 'login-logo');
        $login_image_bg = TMT_Get_Setting($category, 'login-bg');
        $login_color_bg = TMT_Get_Setting($category, 'login-color-bg');
        $login_color_link = TMT_Get_Setting($category, 'login-color-link');
        $login_background_color_submit = TMT_Get_Setting($category, 'login-bg-color-submit');
        $login_color_submit = TMT_Get_Setting($category, 'login-color-submit');
        $login_background_color_submit_hover = TMT_Get_Setting($category, 'login-bg-color-submit-hover');
        $login_color_submit_hover = TMT_Get_Setting($category, 'login-color-submit-hover');

        echo "<style type='text/css'>"
            . "#login {width: 364px !important;}"
            . "#login h1 {background: transparent;padding: 20px;}";
            if ($login_logo) {echo "#login h1 a {background: url($login_logo)  no-repeat center center/contain;height:100px;margin: 0 auto;width:auto;max-width: 100%}";}
            if (!empty($login_background_color_submit || $login_color_submit)) {echo ".wp-core-ui .button-group.button-large .button, .wp-core-ui .button.button-large {background:$login_background_color_submit;color:$login_color_submit;border: 0;border-radius: 0;box-shadow: none;font-weight: 700;height: 30px;line-height: 28px;padding: 1px 12px 2px;text-shadow: none;text-transform: uppercase;}";}
            if (!empty($login_background_color_submit_hover || $login_color_submit_hover)) {echo ".wp-core-ui .button-primary.focus, .wp-core-ui .button-primary.hover, .wp-core-ui .button-primary:focus, .wp-core-ui .button-primary:hover {background:$login_background_color_submit_hover !important;color:$login_color_submit_hover !important;}";}
            if (!empty($login_image_bg)) {echo "body {background: url($login_image_bg)  no-repeat center center/cover !important;width: 100%;height: 100%}";}
            elseif (!empty($login_color_bg)) {echo "body {background:$login_color_bg !important;}";}
            if(!empty($login_color_link)) {echo "#nav a ,#backtoblog a {color:$login_color_link;!important;}";}
        echo "</style>";
    }

    public function get_custom_post_type_template( $archive_template ) {
		global $post;
	
        $post_type = get_option('tmt_main_option', [] );
	    $slug = $post_type['post-type']['slug'];

		if ( is_post_type_archive ( $slug ) ) {
            $archive_template = wp_directory . '/inc/template/archive-portfolio.php';
        }
		return $archive_template;
	}

    public function get_single_post_type_template( $single_template ) {
        global $post;

        $post_type = get_option('tmt_main_option', [] );
	    $slug = $post_type['post-type']['slug'];

		if ( $slug === $post->post_type ) {
            $single_template = wp_directory . '/inc/template/single-portfolio.php';
        }

        if ( 'elementor_library' === $post->post_type ) {
            $single_template = wp_directory . '/inc/template/single-library.php';
        }

        if ( 'mega_menu' === $post->post_type ) {
            $single_template = wp_directory . '/inc/template/single-mega-menu.php';
        }

        return $single_template;
    }
}

new TMT_Front;