<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Karauos
 * @since 3.0.0
 */

get_header();

$theme_option = get_option('tmt_theme_config_option', [] );
$id = $theme_option['tmt-post-archive'];
if(!empty($id)) {
    TMT_Elementor::get_index_content();
} else {
    $args = array(
        'posts_per_page' => 6,
        'post_status' => 'publish',
        'post_type' => 'post',
    );
    $query = new \WP_Query($args);
    echo "<div class='posts' style='max-width: 800px;margin: 0 auto;'>";
    if ( $query->have_posts() ): while ( $query->have_posts() ):$query->the_post();
        $link = get_the_permalink();
        $title = get_the_title();

        echo "<div class='post-item' style='margin: 30px 0;border: 1px solid #000;padding: 20px;'>";
            echo "<a href='$link'>"; tmt_post_thumbnail('large'); echo "</a>";
            echo "<h1><a href='$link'>$title</a></h1>"
            . "<p>"; excerpt_post(100); echo "</p>"
        . "</div>";
    endwhile;endif;wp_reset_postdata();
    echo "</div>";
}
get_footer();
