<?php

function TMT_Get_Setting($category, $id) {
    $main_option = get_option('tmt_main_option', [] );
    $get_category = $main_option[$category];

    return !empty($get_category[$id]) ? $get_category[$id] : '';
}

function seo_title() {
	if(is_singular()){
		$title = get_the_title();
	} elseif (is_category()) {
		$title = single_cat_title( '', false );
	} elseif ( is_tag() ) {
		$title = single_tag_title( '', false );
	} elseif ( is_post_type_archive() ) {
		$title = post_type_archive_title( '', false );
	} elseif ( is_tax() ) {
		$title = single_term_title( '', false );
	} else {
		$title = wp_title( '', false );
	}
	return $title;
}

if ( ! function_exists( 'karauos_the_posts_navigation' ) ) :

    function karauos_the_posts_navigation($number) {
        the_posts_pagination(
            array(
                'mid_size' => $number,
                'prev_text' => ('<i class="fas fa-angle-double-left"></i>'),
                'next_text' => ('<i class="fas fa-angle-double-right"></i>'),
            )
        );
    }
endif;

if ( ! function_exists( 'tmt_post_thumbnail' ) ) :

    function tmt_post_thumbnail($size) {
        if (has_post_thumbnail()) :
            the_post_thumbnail($size, array('alt' => '' . get_the_title() . '', 'title' => '' . get_the_title() . ''));
        else :
            echo '<img src="' . wp_directory_uri . '/assets/images/thumbnail.jpg" alt="' . get_the_title() . '" />';
        endif;
    }
endif;

if ( ! function_exists( 'excerpt_post' ) ) :
    function excerpt_post($number) {
        preg_match("/^([^.!?\s]*[\.!?\s]+){0,$number}/", strip_tags(get_the_content()), $abstract);echo $abstract[0] . '...';
    }
endif;


function TMT_Position() {
    $position_options = [
        ''              => esc_html__('Default', text_domain),
        'top-left'      => esc_html__('Top Left', text_domain) ,
        'top-center'    => esc_html__('Top Center', text_domain) ,
        'top-right'     => esc_html__('Top Right', text_domain) ,
        'center'        => esc_html__('Center', text_domain) ,
        'center-left'   => esc_html__('Center Left', text_domain) ,
        'center-right'  => esc_html__('Center Right', text_domain) ,
        'bottom-left'   => esc_html__('Bottom Left', text_domain) ,
        'bottom-center' => esc_html__('Bottom Center', text_domain) ,
        'bottom-right'  => esc_html__('Bottom Right', text_domain) ,
    ];

    return $position_options;
}


function TMT_Title_Tags() {
    $title_tags = [
        'h1'   => esc_html__( 'H1', text_domain ),
        'h2'   => esc_html__( 'H2', text_domain ),
        'h3'   => esc_html__( 'H3', text_domain ),
        'h4'   => esc_html__( 'H4', text_domain ),
        'h5'   => esc_html__( 'H5', text_domain ),
        'h6'   => esc_html__( 'H6', text_domain ),
        'div'  => esc_html__( 'div', text_domain ),
        'span' => esc_html__( 'span', text_domain ),
        'p'    => esc_html__( 'p', text_domain ),
    ];

    return $title_tags;
}

if ( ! function_exists( 'GFCommon' ) ) :
function themento_gravity_forms_options() {


    if ( class_exists( 'GFCommon' ) ) {
        $contact_forms = RGFormsModel::get_forms( null, 'title' );
        $form_options = ['0' => esc_html__( 'Select Form', text_domain )];
        if ( ! empty( $contact_forms ) && ! is_wp_error( $contact_forms ) ) {
            foreach ( $contact_forms as $form ) {
                $form_options[ $form->id ] = $form->title;
            }
        }
    } else {
        $form_options = ['0' => esc_html__( 'Form Not Found!', text_domain ) ];
    }

    return $form_options;
}
endif;

function add_elementor_widget_categories( $elements_manager ) {
    $elements_manager->add_category(
        text_domain,
        [
            'title' => __( 'Karauos', text_domain ),
            'icon' => 'fa fa-plug',
        ]
    );
    $elements_manager->add_category(
        'single_karauos',
        [
            'title' => __( 'Single Karauos', text_domain ),
            'icon' => 'fa fa-plug',
        ]
    );
    $elements_manager->add_category(
        'shop_karauos',
        [
            'title' => __( 'Shop Karauos', text_domain ),
            'icon' => 'fa fa-plug',
        ]
    );

}
add_action( 'elementor/elements/categories_registered', 'add_elementor_widget_categories' );

if(woo) {
    
   function wc_varb_price_range( $wcv_price, $product ) {
        $prefix = sprintf('%s ', '');
     
        $wcv_reg_min_price = $product->get_variation_regular_price( 'min', true );
        $wcv_min_sale_price    = $product->get_variation_sale_price( 'min', true );
        $wcv_max_price = $product->get_variation_price( 'max', true );
        $wcv_min_price = $product->get_variation_price( 'min', true );
     
        $wcv_price = ( $wcv_min_sale_price == $wcv_reg_min_price ) ?
            wc_price( $wcv_reg_min_price ) :
            '<del>' . wc_price( $wcv_reg_min_price ) . '</del>' . '<ins>' . wc_price( $wcv_min_sale_price ) . '</ins>';
     
        return ( $wcv_min_price == $wcv_max_price ) ?
            $wcv_price :
            sprintf('%s%s', $prefix, $wcv_price);
    }
     
    add_filter( 'woocommerce_variable_sale_price_html', 'wc_varb_price_range', 10, 2 );
    add_filter( 'woocommerce_variable_price_html', 'wc_varb_price_range', 10, 2 );


    if(TMT_Get_Setting('general-settings', 'edpc')) {
        function tmt_addcatagory_description( $category ) {
            if(!empty($category->description)) {echo '<div class="term-description">' . $category->description . '</div>';}
        }
        add_action( 'woocommerce_after_subcategory_title', 'tmt_addcatagory_description', 10, 1 );
    }

    function tmt_woo_remove_wc_breadcrumbs_notices() {
		remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
        remove_action( 'woocommerce_before_single_product', 'woocommerce_output_all_notices', 10 );
	}
    add_action( 'init', 'tmt_woo_remove_wc_breadcrumbs_notices' );

    function tmt_custom_add_to_cart_message() {
		$cart_url = wc_get_cart_url();
		$message = "<div class='tmt-add-to-cart-message flex justify-content-between align-items-center'><p>". esc_html__('Your product has been added to cart.', text_domain) ."</p><a class='button' href='$cart_url'>". esc_html__('View cart', text_domain) ."</a></div>";
		
        return $message;
    }
    add_filter( 'wc_add_to_cart_message_html', 'tmt_custom_add_to_cart_message' );


    add_filter('woocommerce_available_variation', function($available_variations, \WC_Product_Variable $variable, \WC_Product_Variation $variation) {
        if (empty($available_variations['price_html'])) {
            $available_variations['price_html'] = '<span class="price">' . $variation->get_price_html() . '</span>';
        }
    
        return $available_variations;
    }, 10, 3);

    if( is_admin() ) {
        add_filter("product_cat_edit_form_fields", 'filter_wordpress_category_editor');
    }
}

// Remove Wordpress From Admin Pages Titles
function tmt_my_admin_title($admin_title, $title) {
    return $title . ' - ' . get_bloginfo('name');
}
add_filter('admin_title', 'tmt_my_admin_title', 10, 2);
add_filter('login_title', 'tmt_my_admin_title', 10, 2);


if(TMT_Get_Setting('general-settings', 'rd-after-login')) {
    apply_filters('login_redirect','tmt_redirect_after_login');
    function tmt_redirect_after_login(){
        $rd_after_login_url = TMT_Get_Setting('general-settings', 'rd-after-login-url');
        $url = !empty($rd_after_login_url) ? $rd_after_login_url : get_home_url();
        wp_safe_redirect( $url );
        exit;
    }
}

if(TMT_Get_Setting('general-settings', 'rd-after-logout')) {
    add_action('wp_logout','tmt_redirect_after_logout');
    function tmt_redirect_after_logout(){
        $rd_after_logout_url = TMT_Get_Setting('general-settings', 'rd-after-logout-url');
        $url = !empty($rd_after_logout_url) ? $rd_after_logout_url : get_home_url();
        wp_safe_redirect( $url );
        exit;
    }
}

function TMT_Translations() {
    __( 'Current loop', text_domain );
    __('Theme Settings', text_domain);
    __('License registration', text_domain);
}



if(class_exists('WP_Parsidate')){
    if ( get_locale() == 'fa_IR' && !wpp_is_active( 'persian_date' ) ) {
        add_filter( 'the_time', 'wpp_fix_post_time', 10, 2 );
        add_filter( 'the_date', 'wpp_fix_post_date', 10, 2 );
        add_filter( 'get_the_time', 'wpp_fix_post_date', 10, 2 );
        add_filter( 'get_the_date', 'wpp_fix_post_date', 100, 2 );
        add_filter( 'get_comment_time', 'wpp_fix_comment_time', 10, 2 );
        add_filter( 'get_comment_date', 'wpp_fix_comment_date', 10, 2 );
        add_filter( 'date_i18n', 'wpp_fix_i18n', 10, 4 );
        add_filter( 'wp_date', 'wpp_fix_i18n', 10, 4 );
    }
}

if( is_admin() ) {
    remove_filter( 'pre_term_description', 'wp_filter_kses' );
    remove_filter( 'term_description', 'wp_kses_data' );
	$taxonomy_slug = TMT_Get_Setting('taxonomy', 'cat-slug');
    add_filter('edit_category_form_fields', 'filter_wordpress_category_editor');
    add_filter("{$taxonomy_slug}_edit_form_fields", 'filter_wordpress_category_editor');
    function filter_wordpress_category_editor($tag) {
        ?>
        <table class="form-table">
            <tr class="form-field">
                <th scope="row" valign="top"><label for="description"><?php _e('Description'); ?></label></th>
                <td>
                <?php
                    $settings = array('wpautop' => true, 'media_buttons' => true, 'quicktags' => true, 'textarea_rows' => '15', 'textarea_name' => 'description' );  
              wp_editor(html_entity_decode($tag->description , ENT_QUOTES, 'UTF-8'), 'description1', $settings);
                ?>
                </td>
            </tr>
        </table>
        <?php
    }
    
    add_action('admin_head', 'remove_default_category_description');
    function remove_default_category_description() {
        global $current_screen;
		$taxonomy_slug = TMT_Get_Setting('taxonomy', 'cat-slug');
        if ( $current_screen->id == 'edit-category' || $current_screen->id == "edit-$taxonomy_slug" || $current_screen->id == "edit-product_cat" ) {
        ?>
            <script type="text/javascript">
            jQuery(function($) {
                $('textarea#description').closest('tr.form-field').remove();
            });
            </script>
        <?php
        }
    }
}

add_action('after_switch_theme', 'tmt_after_switch_theme_update');
function tmt_after_switch_theme_update() {
    do_action('tmt_update_custom_styles');
}

add_action('upgrader_process_complete', 'tmt_on_theme_update', 10, 2);
function tmt_on_theme_update($upgrader_object, $options) {
    if ($options['action'] === 'update' && $options['type'] === 'theme') {
        do_action('tmt_update_custom_styles');
    }
}

if(! get_option('dismissed_tmt_admin_notice')) {
    function tmt_admin_notice() {
        echo '<div class="notice notice-error tmt-admin-notice"><p>بعد از بروزرسانی قالب در صورت وجود بهم ریختگی در ظاهر سایت و پنل تنظیمات ابتدا وارد منو المنتور >> ابزار ها شوید و یکبار دکمه "بازسازی فایل‌ها و داده" را بزنید. سپس از پشخوان وردپرس وارد منو تنظیمات قالب شوید و یکبار تنظیمات را ذخیره کنید.
            در  نهایت جهت مشاهده تغییرات در پنل تنظیمات و خروجی سایت یکبار کلید های ترکیبی Ctrl + F5 را بزنید.</p><a id="tmt-notice-closed" class="button-primary" style="margin-bottom: 10px;background-color: #d63638;border-color: #d63638;" href="#">بستن پیغام</a></div>';
    }
    add_action('admin_notices', 'tmt_admin_notice');
}

add_action('wp_ajax_tmt_close_notice_action', 'tmt_close_notice_action_callback');
function tmt_close_notice_action_callback() {
    update_option('dismissed_tmt_admin_notice', true);
    die();
}

add_action('admin_footer', 'tmt_inline_admin_script');
function tmt_inline_admin_script() {
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('#tmt-notice-closed').click(function(e) {
                e.preventDefault();
                var notice = $('.tmt-admin-notice');
                $.ajax({
                    type: 'POST',
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    data: {
                        action: 'tmt_close_notice_action'
                    },
                    success: function(response) {
                        notice.slideUp(100, function() {
                            notice.slideUp();
                        });
                    }
                });
            });
        });
    </script>
    <?php
}