<?php

class Security {

    public function __construct() {
        $category = 'general-settings';

        if(TMT_Get_Setting($category, 'disable-editor-theme-plugin')) {
            define( 'DISALLOW_FILE_EDIT', true );
        }
        if(TMT_Get_Setting($category, 'disable-wp-version')) {
            add_filter('the_generator', [$this, 'remove_wordpress_version_number']);
        }
        if(TMT_Get_Setting($category, 'disable-wp-users-rest-api')) {
            add_filter('rest_endpoints', [$this, 'disable_wordpress_users_rest_api']);
        }
    }
      
    public function remove_wordpress_version_number() {
          return '';
    }

    public function disable_wordpress_users_rest_api($endpoints) {
        if ( isset( $endpoints['/wp/v2/users'] ) ) {
            unset( $endpoints['/wp/v2/users'] );
        }
        if ( isset( $endpoints['/wp/v2/users/(?P<id>[d]+)'] ) ) {
            unset( $endpoints['/wp/v2/users/(?P<id>[d]+)'] );
        }
        return $endpoints;
    }
}

new Security;