<?php

class Optimization {

    public function __construct() {
        $category = 'general-settings';

        // add_action( 'wp_enqueue_scripts', [$this, 'Dregister_Script'] );
        if(TMT_Get_Setting($category, 'disable-jquery-migrate')) {
            add_action('wp_default_scripts', [$this, 'tmt_remove_jquery_migrate']);
        }
        if(TMT_Get_Setting($category, 'disable-emojis')) {
            add_action('init', [$this, 'tmt_disable_emojis']);
        }
        if(TMT_Get_Setting($category, 'disable-embeds')) {
            add_action('init', [$this, 'tmt_disable_embeds'], 9999);
        }
        if(TMT_Get_Setting($category, 'disable-global-styles')) {
            remove_action( 'wp_enqueue_scripts', 'wp_enqueue_global_styles' );
            remove_action( 'wp_footer', 'wp_enqueue_global_styles', 1 );
            remove_action( 'wp_body_open', 'wp_global_styles_render_svg_filters' );
        }
        if(TMT_Get_Setting($category, 'enable-classic-editor')) {
            add_filter('use_block_editor_for_post', '__return_false');
            add_filter('use_block_editor_for_post_type', '__return_false', 10);
            remove_action('try_gutenberg_panel', 'wp_try_gutenberg_panel');
        }
        if(TMT_Get_Setting($category, 'disable-shortlink')) {
            remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);
        }
    }

    public function Dregister_Script() {
        wp_dequeue_style( 'wp-block-library' );
    }

    public function tmt_remove_jquery_migrate($scripts){
        if (!is_admin() && isset($scripts->registered['jquery'])) {
            $script = $scripts->registered['jquery'];
            
            if ($script->deps) {
                $script->deps = array_diff($script->deps, array(
                    'jquery-migrate'
                ));
            }
        }
    }

    public function tmt_disable_emojis(){
        remove_action('wp_head', 'print_emoji_detection_script', 7);
        remove_action('admin_print_scripts', 'print_emoji_detection_script');
        remove_action('wp_print_styles', 'print_emoji_styles');
        remove_action('admin_print_styles', 'print_emoji_styles');	
        remove_filter('the_content_feed', 'wp_staticize_emoji');
        remove_filter('comment_text_rss', 'wp_staticize_emoji');	
        remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
        add_filter('emoji_svg_url', '__return_false');
    }

    public function tmt_disable_embeds() {
        global $wp;
        $wp->public_query_vars = array_diff($wp->public_query_vars, array('embed'));
        add_filter('embed_oembed_discover', '__return_false');
        remove_filter('oembed_dataparse', 'wp_filter_oembed_result', 10);
        remove_action('wp_head', 'wp_oembed_add_discovery_links');
        remove_action('wp_head', 'wp_oembed_add_host_js');
        add_filter('tiny_mce_plugins', [$this, 'tmt_disable_embeds_tiny_mce_plugin']);
        add_filter('rewrite_rules_array', [$this, 'tmt_disable_embeds_rewrites']);
        remove_filter('pre_oembed_result', 'wp_filter_pre_oembed_result', 10);
    }

    public function tmt_disable_embeds_tiny_mce_plugin($plugins) {
        return array_diff($plugins, array('wpembed'));
    }
    
    public function tmt_disable_embeds_rewrites($rules) {
        foreach($rules as $rule => $rewrite) {
            if(false !== strpos($rewrite, 'embed=true')) {
                unset($rules[$rule]);
            }
        }
        return $rules;
    }
}

new Optimization;