<?php

function karauos_customize_register( $wp_customize ) {

    $wp_customize->add_panel( 'karauos_panel',array(
        'title' => __( 'karauos Settings', text_domain ),
        'priority' => 1,
    ));

    // Header Settings
    $wp_customize->add_section( 'header_settings' , array(
        'title'       => __( 'Header Settings', text_domain ),
        'priority'    => 30,
        'panel' => 'karauos_panel',
    ) );

    $wp_customize->add_setting( 'tmt_header_page_template', array('default' => '0') );
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tmt_header_page_template', array(
        'label'	   				=> esc_html__( 'Header Select Template', text_domain ),
        'description'	   		=> esc_html__( 'Choose a template created in Theme Panel > My Library.', text_domain ),
        'type' 					=> 'select',
        'section'  				=> 'header_settings',
        'settings' 				=> 'tmt_header_page_template',
        'priority' 				=> 1,
        'choices' 				=> tmt_customizer_elementor_library( 'library' ),
    ) ) );

    $wp_customize->add_setting( 'checkbox_setting_id', array('capability' => 'edit_theme_options') );
    $wp_customize->add_control( 'checkbox_setting_id', array(
      'type' => 'checkbox',
      'section' => 'header_settings', // Add a default or your own section
      'label' => __( 'Absolute Header', text_domain ),
    ) );

    $wp_customize->add_setting( 'checkbox_setting_id_mobile', array('capability' => 'edit_theme_options') );
    $wp_customize->add_control( 'checkbox_setting_id_mobile', array(
      'type' => 'checkbox',
      'section' => 'header_settings', // Add a default or your own section
      'label' => __( 'Absolute Header (Mobile)', text_domain ),
    ) );

    // Footer Settings
    $wp_customize->add_section( 'footer_settings' , array(
        'title'       => __( 'Footer Settings', text_domain ),
        'priority'    => 30,
        'panel' => 'karauos_panel',
    ) );

    $wp_customize->add_setting( 'tmt_footer_page_template', array('default' => '0') );
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tmt_footer_page_template', array(
        'label'	   				=> esc_html__( 'Footer Select Template', text_domain ),
        'description'	   		=> esc_html__( 'Choose a template created in Theme Panel > My Library.', text_domain ),
        'type' 					=> 'select',
        'section'  				=> 'footer_settings',
        'settings' 				=> 'tmt_footer_page_template',
        'priority' 				=> 1,
        'choices' 				=> tmt_customizer_elementor_library( 'library' ),
    ) ) );

    // Archive Settings
    $wp_customize->add_section( 'archive_settings' , array(
        'title'       => __( 'Archive Page Settings', text_domain ),
        'priority'    => 30,
        'panel' => 'karauos_panel',
    ) );

    $wp_customize->add_setting( 'tmt_index_page_template', array('default' => '0') );
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tmt_index_page_template', array(
        'label'	   				=> esc_html__( 'Archive Page Select Template', text_domain ),
        'description'	   		=> esc_html__( 'Choose a template created in Theme Panel > My Library.', text_domain ),
        'type' 					=> 'select',
        'section'  				=> 'archive_settings',
        'settings' 				=> 'tmt_index_page_template',
        'priority' 				=> 1,
        'choices' 				=> tmt_customizer_elementor_library( 'library' ),
    ) ) );

    $wp_customize->add_setting( 'tmt_project_page_template', array('default' => '0') );
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tmt_project_page_template', array(
        'label'	   				=> esc_html__( 'Archive Project Select Template', text_domain ),
        'description'	   		=> esc_html__( 'Choose a template created in Theme Panel > My Library.', text_domain ),
        'type' 					=> 'select',
        'section'  				=> 'archive_settings',
        'settings' 				=> 'tmt_project_page_template',
        'priority' 				=> 1,
        'choices' 				=> tmt_customizer_elementor_library( 'library' ),
    ) ) );

    if(woo) {
        $wp_customize->add_setting( 'tmt_shop_page_template', array('default' => '0') );
        $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tmt_shop_page_template', array(
            'label'	   				=> esc_html__( 'Archive Shop Select Template', text_domain ),
            'description'	   		=> esc_html__( 'Choose a template created in Theme Panel > My Library.', text_domain ),
            'type' 					=> 'select',
            'section'  				=> 'archive_settings',
            'settings' 				=> 'tmt_shop_page_template',
            'priority' 				=> 1,
            'choices' 				=> tmt_customizer_elementor_library( 'library' ),
        ) ) );
    }


    // Single Settings
    $wp_customize->add_section( 'single_settings' , array(
        'title'       => __( 'Single Page Settings', text_domain ),
        'priority'    => 30,
        'panel' => 'karauos_panel',
    ) );

    $wp_customize->add_setting( 'tmt_single_page_template', array('default' => '0') );
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tmt_single_page_template', array(
        'label'	   				=> esc_html__( 'Single Post Select Template', text_domain ),
        'description'	   		=> esc_html__( 'Choose a template created in Theme Panel > My Library.', text_domain ),
        'type' 					=> 'select',
        'section'  				=> 'single_settings',
        'settings' 				=> 'tmt_single_page_template',
        'priority' 				=> 1,
        'choices' 				=> tmt_customizer_elementor_library( 'library' ),
    ) ) );

    $wp_customize->add_setting( 'tmt_single_project_template', array('default' => '0') );
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tmt_single_project_template', array(
        'label'	   				=> esc_html__( 'Single Project Select Template', text_domain ),
        'description'	   		=> esc_html__( 'Choose a template created in Theme Panel > My Library.', text_domain ),
        'type' 					=> 'select',
        'section'  				=> 'single_settings',
        'settings' 				=> 'tmt_single_project_template',
        'priority' 				=> 1,
        'choices' 				=> tmt_customizer_elementor_library( 'library' ),
    ) ) );

    if(woo) {
        $wp_customize->add_setting( 'tmt_single_shop_page_template', array('default' => '0') );
        $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tmt_single_shop_page_template', array(
            'label'	   				=> esc_html__( 'Single Shop Select Template', text_domain ),
            'description'	   		=> esc_html__( 'Choose a template created in Theme Panel > My Library.', text_domain ),
            'type' 					=> 'select',
            'section'  				=> 'single_settings',
            'settings' 				=> 'tmt_single_shop_page_template',
            'priority' 				=> 1,
            'choices' 				=> tmt_customizer_elementor_library( 'library' ),
        ) ) );
    }

    $wp_customize->add_setting( 'tmt_static_page_template', array('default' => '0') );
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tmt_static_page_template', array(
        'label'	   				=> esc_html__( 'Static Page Select Template', text_domain ),
        'description'	   		=> esc_html__( 'Choose a template created in Theme Panel > My Library.', text_domain ),
        'type' 					=> 'select',
        'section'  				=> 'single_settings',
        'settings' 				=> 'tmt_static_page_template',
        'priority' 				=> 1,
        'choices' 				=> tmt_customizer_elementor_library( 'library' ),
    ) ) );


    // Error Settings
    $wp_customize->add_section( 'error_settings' , array(
        'title'       => __( '404 Error Page Settings', text_domain ),
        'priority'    => 30,
        'panel' => 'karauos_panel',
    ) );

    $wp_customize->add_setting( 'tmt_error_page_template', array('default' => '0') );
    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'tmt_error_page_template', array(
        'label'	   				=> esc_html__( 'Error Page Select Template', text_domain ),
        'description'	   		=> esc_html__( 'Choose a template created in Theme Panel > My Library.', text_domain ),
        'type' 					=> 'select',
        'section'  				=> 'error_settings',
        'settings' 				=> 'tmt_error_page_template',
        'priority' 				=> 1,
        'choices' 				=> tmt_customizer_elementor_library( 'library' ),
    ) ) );

    /*
	* Login WP
	**/
    $wp_customize->add_section( 'wp_login', array(
        'title'       => __( 'WP Login', text_domain ),
        'priority'    => 30,
        'panel'       => 'karauos_panel',
    ) );
    $wp_customize->add_setting( 'login_logo' );
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'login_logo', array(
        'label'    => __( 'Login Logo', text_domain ),
        'section'  => 'wp_login',
        'settings' => 'login_logo',
    )));
    $wp_customize->add_setting( 'login_color_bg', array( 'default'   => '','transport' => 'refresh','sanitize_callback' => 'sanitize_hex_color',) );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'login_color_bg', array(
    'section' => 'wp_login',
    'label'   => __( 'Login Background Color', text_domain ),
    ) ) );

    $wp_customize->add_setting( 'login_image_bg' );
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'login_image_bg', array(
        'label'    => __( 'Login Background image', text_domain ),
        'section'  => 'wp_login',
        'settings' => 'login_image_bg',
    )));
    $wp_customize->add_setting( 'login_color_link', array( 'default'   => '','transport' => 'refresh','sanitize_callback' => 'sanitize_hex_color',) );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'login_color_link', array(
    'section' => 'wp_login',
    'label'   => __( 'Login Color Links', text_domain ),
    ) ) );
    $wp_customize->add_setting( 'login_background_color_submit', array( 'default'   => '','transport' => 'refresh','sanitize_callback' => 'sanitize_hex_color',) );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'login_background_color_submit', array(
    'section' => 'wp_login',
    'label'   => __( 'Login Background Color Submit', text_domain ),
    ) ) );
    $wp_customize->add_setting( 'login_color_submit', array( 'default'   => '','transport' => 'refresh','sanitize_callback' => 'sanitize_hex_color',) );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'login_color_submit', array(
    'section' => 'wp_login',
    'label'   => __( 'Login Color Text Submit', text_domain ),
    ) ) );
    $wp_customize->add_setting( 'login_background_color_submit_hover', array( 'default'   => '','transport' => 'refresh','sanitize_callback' => 'sanitize_hex_color',) );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'login_background_color_submit_hover', array(
    'section' => 'wp_login',
    'label'   => __( 'Login Background Color Submit Hover', text_domain ),
    ) ) );
    $wp_customize->add_setting( 'login_color_submit_hover', array( 'default'   => '','transport' => 'refresh','sanitize_callback' => 'sanitize_hex_color',) );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'login_color_submit_hover', array(
    'section' => 'wp_login',
    'label'   => __( 'Login Text Color Submit Hover', text_domain ),
    ) ) );

    /*
	*  Main Color Option
	**/
    $wp_customize->add_section( 'colors', array(
        'title'       => __( 'Colors', text_domain ),
        'priority'    => 30,
        'panel'       => 'karauos_panel',
    ) );
    $wp_customize->add_setting( 'select_text_color', array( 'default'   => '#fff','transport' => 'refresh','sanitize_callback' => 'sanitize_hex_color',) );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'select_text_color', array(
    'section' => 'colors',
    'label'   => __( 'Select Text Color', text_domain ),
    ) ) );
    $wp_customize->add_setting( 'select_bg_color', array( 'default'   => '#eead16','transport' => 'refresh','sanitize_callback' => 'sanitize_hex_color',) );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'select_bg_color', array(
    'section' => 'colors',
    'label'   => __( 'Select Background Color', text_domain ),
    ) ) );
    $wp_customize->add_setting( 'link_color', array( 'default'   => '#eead16','transport' => 'refresh','sanitize_callback' => 'sanitize_hex_color',) );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_color', array(
    'section' => 'colors',
    'label'   => __( 'Link Color', text_domain ),
    ) ) );
    $wp_customize->add_setting( 'mobile_color', array( 'default'   => '#eead16','transport' => 'refresh','sanitize_callback' => 'sanitize_hex_color',) );
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'mobile_color', array(
    'section' => 'colors',
    'label'   => __( 'Mobile Tab Color', text_domain ),
    ) ) );
    


    /*
    *  Fonts
    **/
    $wp_customize->add_section( 'custom_fonts_section', array(
            'title'    => __( 'Template Fonts', text_domain ),
            'description'	   		=> '<a href="https://www.themento.net/fa/2656/" target="_blank">برای قرار دادن فونت اختصاصی کلیک کنید تا آموزش را مشاهده کنید.</a>',
            'panel'    => 'karauos_panel',
            'priority' => 50,
        )
    );

    $wp_customize->add_setting( 'custom_font', array(
        'sanitize_callback' => 'customizer_repeater_sanitize'
     ));
     $wp_customize->add_control( new Customizer_Repeater( $wp_customize, 'custom_font', array(
        'label'   => __('Fonts',text_domain),
        'section' => 'custom_fonts_section',
        'priority' => 1,
    ) ) );
        

    /*
	*  Custom codes
	**/
    $wp_customize->add_section( 'custom_codes', array(
        'title'       => __( 'Custom codes', text_domain ),
        'priority'    => 30,
        'panel'       => 'karauos_panel',
    ) );

    $wp_customize->add_setting( 'custom_css', array('default' => '', 'transport' => 'refresh',));
    $wp_customize->add_control( 'custom_css',
        array(
            'label' => __( 'Custom CSS', text_domain ),
            'section' => 'custom_codes',
            'priority' => 10, // Optional. Order priority to load the control. Default: 10
            'type' => 'textarea',
            'capability' => 'edit_theme_options', // Optional. Default: 'edit_theme_options'
        )
    );

    $wp_customize->add_setting( 'custom_js', array('default' => '', 'transport' => 'refresh',));
    $wp_customize->add_control( 'custom_js',
        array(
            'label' => __( 'Custom JS', text_domain ),
            'section' => 'custom_codes',
            'priority' => 10, // Optional. Order priority to load the control. Default: 10
            'type' => 'textarea',
            'capability' => 'edit_theme_options', // Optional. Default: 'edit_theme_options'
        )
    );

    $wp_customize->add_setting( 'before_closing_head', array('default' => '', 'transport' => 'refresh',));
    $wp_customize->add_control( 'before_closing_head',
        array(
            'label' => __( 'Before Closing Head Tag', text_domain ),
            'section' => 'custom_codes',
            'priority' => 10, // Optional. Order priority to load the control. Default: 10
            'type' => 'textarea',
            'capability' => 'edit_theme_options', // Optional. Default: 'edit_theme_options'
        )
    );

    $wp_customize->add_setting( 'before_closing_body', array('default' => '', 'transport' => 'refresh',));
    $wp_customize->add_control( 'before_closing_body',
        array(
            'label' => __( 'Before Closing Body Tag', text_domain ),
            'section' => 'custom_codes',
            'priority' => 10, // Optional. Order priority to load the control. Default: 10
            'type' => 'textarea',
            'capability' => 'edit_theme_options', // Optional. Default: 'edit_theme_options'
        )
    );

}

add_action( 'customize_register', 'karauos_customize_register' );