<?php

use Themento\Admin\Config_Setting;


if(is_admin()) {
    require wp_directory .'/admin/class-admin.php';
}
require wp_directory .'/admin/class-config-settings.php';
require wp_directory .'/inc/front.php';

$main_option = get_option('tmt_main_option', [] );
if(empty($main_option)) {
    
    require wp_directory . '/inc/customizer/customizer-repeater/functions.php';
    require wp_directory .'/inc/customizer/customizer.php';


    $elements = new Config_Setting();
    $elements = $elements->Elementor_Elements();
    foreach($elements as $element) {
        $id = $element['id'];
        $tmt_modules_option["$id"] = true;
    }

    update_option('tmt_active_modules_option', $tmt_modules_option);

    $theme_config = [
        'tmt-header'            => get_theme_mod( 'tmt_header_page_template'),
        'tmt-footer'            => get_theme_mod( 'tmt_footer_page_template'),
        'tmt-post-archive'      => get_theme_mod( 'tmt_index_page_template'),
        'tmt-project-archive'   => get_theme_mod( 'tmt_project_page_template'),
        'tmt-single-post'       => get_theme_mod( 'tmt_single_page_template'),
        'tmt-single-project'    => get_theme_mod( 'tmt_single_project_template'),
        'tmt-static-page'       => get_theme_mod( 'tmt_static_page_template'),
        'tmt-error-404-page'    => get_theme_mod( 'tmt_error_page_template'),
        'tmt-shop'              => get_theme_mod( 'tmt_shop_page_template'),
        'tmt-single-shop'       => get_theme_mod( 'tmt_single_shop_page_template'),
    ];
    
    update_option('tmt_theme_config_option', $theme_config);
    
    $projects = __('Projects', text_domain);
    $project = __('Project', text_domain);

    $defult_settings = [
        'general-settings' => [
            'abs-header'            => get_theme_mod( 'checkbox_setting_id'),
            'abs-header-mobile'     => get_theme_mod( 'checkbox_setting_id_mobile'),
            'rd-after-login'        => false,
            'rd-after-login-url'    => '',
            'rd-after-logout'       => false,
            'rd-after-logout-url'   => '',
            'select-text-color'     => get_theme_mod( 'select_text_color', '#FFF'),
            'select-bg-color'       => get_theme_mod( 'select_bg_color', '#eead16'),
            'link-color'            => get_theme_mod( 'link_color', '#eead16'),
            'mobile-color'          => get_theme_mod( 'mobile_color', '#eead16'),
            'edpc'                  => true,
            'enable-preloader'      => false,
            'preloader-style'       => sanitize_text_field('style1'),
            'preloader-bg-color'    => '#214EEC',
            'preloader-logo'        => '',
            'ltr-font'              => sanitize_text_field('Open Sans'),
        ],
        'login-settings' => [
            'login-logo'                    => get_theme_mod( 'login_logo'),
            'login-bg'                      => get_theme_mod( 'login_image_bg'),
            'login-color-bg'                => get_theme_mod( 'login_color_bg'),
            'login-color-link'              => get_theme_mod( 'login_color_link'),
            'login-bg-color-submit'         => get_theme_mod( 'login_background_color_submit'),
            'login-color-submit'            => get_theme_mod( 'login_color_submit'),
            'login-bg-color-submit-hover'   => get_theme_mod( 'login_background_color_submit_hover'),
            'login-color-submit-hover'      => get_theme_mod( 'login_color_submit_hover'),
        ],
        'codes-settings' => [
            'custom-css'            => get_theme_mod( 'custom_css'),
            'custom-js'             => get_theme_mod( 'custom_js'),
            'custom-before-head'    => get_theme_mod( 'before_closing_head'),
            'custom-before-body'    => get_theme_mod( 'before_closing_body'),
        ],
        'post-type' => [
            'slug'      => sanitize_text_field('portfolio'),
            'name'      => sanitize_text_field($projects),
            'singular'  => sanitize_text_field($project),
        ],
        'taxonomy' => [
            'cat-slug'  => sanitize_text_field('portfolio_cat'),
            'tag-slug'  => sanitize_text_field('portfolio_tags'),
        ],
        'fonts' => '',
    ];
    
    $custom_font = get_theme_mod('custom_font', json_encode( array()) );
    $custom_font_decoded = json_decode($custom_font);
    $EOT_url = $TTF_url = $WOFF_url = $css = '';
    if(!empty($custom_font_decoded)) {foreach($custom_font_decoded as $repeater_item){$EOT_url = $repeater_item->EOT_url;$TTF_url = $repeater_item->TTF_url;$WOFF_url = $repeater_item->WOFF_url;}}
    if(!empty($EOT_url) || !empty($TTF_url) || !empty($WOFF_url)) {
        foreach($custom_font_decoded as $repeater_item){
            $defult_settings['fonts'][''] = [
                'weight'    => sanitize_text_field($repeater_item->font_weight),
                'woff'      => sanitize_url($repeater_item->WOFF_url),
                'woff2'     => sanitize_url($repeater_item->WOFF2_url),
                'ttf'       => sanitize_url($repeater_item->TTF_url),
                'svg'       => sanitize_url($repeater_item->SVG_url),
                'eot'       => sanitize_url($repeater_item->EOT_url),
            ];
        }
    }
    
    update_option('tmt_main_option', $defult_settings);
}